#include <bits/stdc++.h>
#define MAX_TREE_SIZE 400005

using namespace std;

int n;
int tree[MAX_TREE_SIZE];

void addq(int k, int x) {
    k += n;
    tree[k] = x;
    for(k = k / 2; k >= 1; k /= 2) {
        tree[k] = tree[2 * k] & tree[2 * k + 1];
    }
}

int sumq(int a, int b) {
    a += n;
    b += n;
    int res = -1;
    while(a <= b) {
        if(a % 2 == 1) {
            res = res & tree[a];
            a++;
        }
        if(b % 2 == 0) {
            res = res & tree[b];
            b--;
        }
        a /= 2;
        b /= 2;
    }
    return res;
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);
    cin >> n;
    int arr[n];
    for(int i = 0; i < n; i++) {
        cin >> arr[i];
    }
    int temp_n = n;
    if(__builtin_popcount(n) != 1) {
        n = 1 << (__builtin_clz(1) - __builtin_clz(n) + 1);
    }
    fill(tree, tree + n, -1);
    for(int i = 0; i < temp_n; i++) {
        addq(i, arr[i]);
    }
    int q;
    cin >> q;
    while(q--) {
        int t;
        cin >> t;
        if(t == 1) {
            int x, y;
            cin >> x >> y;
            x--;
            addq(x, y);
        } else {
            int x;
            cin >> x;
            x--;
            int ans = numeric_limits<int>::max();
            //ans = min(ans, min(x - i, j - x) + (j - i));
            for(int i = 0; i <= x; i++) {
                int l = x, r = temp_n - 1;
                while(l <= r) {
                    int mid = l + (r - l) / 2;
                    if(sumq(i, mid) == 0) {
                        ans = min(ans, min(x - i, mid - x) + (mid - i));
                        r = mid - 1;
                    } else {
                        l = mid + 1;
                    }
                }
            }
            if(ans == numeric_limits<int>::max()) {
                cout << -1 << "\n";
            } else {
                cout << ans << "\n";
            }
        }
    }
    return 0;
}